/*
 *
 *  Copyright (C) 2008-2009 RICOH Co.,LTD.
 *  All rights reserved.
 *
 *  affiliation	:DSS Development Center
 *  		 Document Solutions & Services Division
 * 
 *  purpose	: OCF card service bundle sample.
 *
 */

package ocfbundle;
import java.util.ArrayList;
import java.util.Iterator;

import opencard.core.service.CardServiceFactory;
import opencard.core.service.CardServiceRegistry;
import opencard.core.service.SmartCard;
import opencard.core.util.Tracer;

import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;

/**
 * OCFCardServiceBundle class
 * This is a card service bundle of the OCF.
 * This class implements BundleActivator.
 * This class registers/removes MyAppletService and MyFileAccessService 
 * to/from the card service registry.
 * 
 * OCFCardServiceBundleクラス
 * OCFのカードサービスバンドルです。
 * BundleActivatorを実装します。
 * MyAppletService、MyFileAccessServiceをカードサービスレジストリに登録/削除します。
 */
public class OCFCardServiceBundle implements BundleActivator {
	
	/**
	 * The ArrayList which stores card service factories which this bundle registered.
	 * 
	 * このバンドルがレジストリに登録したCardServiceFactoryのリストです。
	 */
	private ArrayList list = new ArrayList();
	
	/**
	 * The Tracer object.
	 * 
	 * Tracerです。
	 */
	private Tracer itracer = new Tracer(this, OCFCardServiceBundle.class);
	
	/**
	 * The BundleContext object.
	 * 
	 * バンドルのコンテキストです。
	 */
	protected BundleContext context = null;
	
	/* (non-Javadoc)
	 * @see org.osgi.framework.BundleActivator#start(org.osgi.framework.BundleContext)
	 */
	synchronized public final void start(BundleContext context) throws Exception {
		this.context = context;
		boolean smartCardStarted = false;
		boolean isOk = false;
		
		try{
			SmartCard.start();
			smartCardStarted = true;
			
			Class[] cs = null;
			try{
				 cs = getCardServices();
				
			}catch (Throwable e){
				itracer.debug("start", "[OCF]The exception thrown from a getCardService : " + e);
				e.printStackTrace();
				if (e instanceof Error) {
					throw (Error) e;
				}
				throw (Exception) e;
			}
			
			CardServiceRegistry registry = CardServiceRegistry.getRegistry();
			if(cs!=null){
				for(int i=0; i<cs.length; i++){
					registry.add((CardServiceFactory)cs[i].newInstance());
					list.add(cs[i]);
					System.out.println("[OCF]registered : " + cs[i].getName());
				}
			}
			
			isOk = true;
			
		} catch (Throwable e) {e.printStackTrace();throw new Exception();
		
		} finally {
			if(!isOk){
				remove();
				
				if (smartCardStarted) {
					SmartCard.shutdown();
				}
			}
		}
	}
	
	/* (non-Javadoc)
	 * @see org.osgi.framework.BundleActivator#stop(org.osgi.framework.BundleContext)
	 */
	synchronized public final void stop(BundleContext context) throws Exception {
		try{
			remove();
			
			SmartCard.shutdown();
			
		}catch(Throwable e){
			e.printStackTrace();
		}
	}
	
	/**
	 * Removes all card service factories which this bundle registered.
	 * 
	 * このバンドルが登録したCardServiceFactoryをレジストリから削除します。
	 */
	private void remove() {
		CardServiceRegistry registry = CardServiceRegistry.getRegistry();
		Class c = null;
		
		Iterator it = list.iterator();
		while(it.hasNext()){
			try{
				c = (Class)it.next();
				registry.remove((CardServiceFactory)c.newInstance());
				//itracer.debug("start", "[OCF]removed : " + c.getName());
				System.out.println("[OCF]removed : " + c.getName());
				
			}catch(Throwable e){
				itracer.debug("start", "[OCF]Not removed : " + c.getName());
			}
		}
		
		list.clear();
	}
	
	/**
	 * Returns card service factories which this bundle registers.
	 * 
	 * このバンドルで登録するCardServiceFactoryを返します。
	 */
	private Class[] getCardServices() throws Exception {
		return new Class[]{
				MyFactory.class
		};
	}
}